void setup()
{
  size(500, 500);
}

/*
Abstract:
 _r を中心とした円状に円を並べて描画する。回転描画する円の半径は、_rと_nの値で自動的に他辺と接する値に調整される。
 
 Parameter:
 _x : 基準となる中心座標 x 
 _y : 基準となる中心座標 y
 _r : 基準となる円の半径
 _angle : 基準となる円の傾き（角度）
 _arc_begin : 回転描画する円弧の書き出し位置（角度）
 _arc_length : 回転描画する円弧の長さ（角度）
 _n : 回転描画する円の個数
 */
void drawRevolvingPattern(
  float _x, float _y, float _r, 
  float _angle, float _arc_begin, float _arc_length, 
  int _n)
{
  float _angle_step = 360.0/(float)_n;
  float r_sub = _r*2*cos(radians((180.0-_angle_step)/2.0));  
  noFill();
  for (float i = -90; i < 360-90; i=i+_angle_step) {
    arc(_x+_r*cos(radians(i+_angle)), _y+_r*sin(radians(i+_angle)), 
      r_sub, r_sub, 
      radians(_angle + i+_arc_begin), radians(_angle + i+ _arc_begin + _arc_length));
  }
}


/*
Abstract: 
 (_x, _y) を中心として、_n 個の直線を均等に放射状に_rの長さだけ描画する。

Parameter
 _x : 基準となる中心座標 x
 _y : 基準となる中心座標 y
 _r : 直線の長さ
 _angle : 放射直線の回転角度
 _n : 放射直線の数
*/
void drawRadialWire(
  float _x, float _y, float _r, 
  float _angle, 
  int _n)
{
  float angle_step = 360/(float)_n;
  for ( float i = -90; i < 360-90; i=i+angle_step ) {
    line(_x, _y, _x+_r*cos(radians(i+_angle)), _y+_r*sin(radians(i+_angle)));
  }
}

void draw()
{
  background(255);
  strokeWeight(1);
  stroke(0);
  drawRevolvingPattern(width/2, height/2, 150, 0, -90, 180, 10);
  drawRadialWire(width/2, height/2, 150, 18, 10);
  fill(255);
  ellipse(width/2, height/2, 50, 50);
}


void keyPressed()
{
  if ( key == 's' ) {
    save("output.png");
  }
}
