/**
 * Clock. 
 * 
 * The current time can be read with the second(), minute(), 
 * and hour() functions. In this example, sin() and cos() values
 * are used to set the position of the hands.
 
 このプログラムはProcessing ExampleにあるClock(Basics -> Input -> Clock)をベースとしています。
 平成29年7月3日　馬場哲晃
 */


int cx, cy; // 文字盤の中心位置（画面中心座標）
float secondsRadius; // 秒針の長さ
float minutesRadius; // 分針の長さ
float hoursRadius;   // 時針の長さ
float numberRadius;  // 文字盤の時間文字の描画位置
float nickRadius;    // 刻みの描画位置
float clockDiameter; // 時計全体の直径
float clockRadius;
PFont f;                        // Font表示用

void setup() {
  size(800, 800);
  pixelDensity(displayDensity());

  stroke(255);
  strokeCap(SQUARE); 

  f = createFont("HelveticaNeue-UltraLight.otf", 28);  
  textFont(f); // 読み込んだフォント f を表示用テキストフォントに変更
  textAlign(CENTER, CENTER); // 表示基準を中心に設定
  int radius = min(width-100, height-100) / 2; // 文字盤半径の基準は縦幅、横幅のどちらか大きい方に合わせる

  clockDiameter = radius * 2.0;
  clockRadius = clockDiameter/2.0;
  secondsRadius = clockRadius * 0.90;
  minutesRadius = clockRadius * 0.80;
  hoursRadius = clockRadius * 0.70;
  numberRadius = clockRadius*0.70;
  nickRadius = clockRadius*0.95;

  cx = width / 2;
  cy = height / 2;
}

void draw() {

  // 背景色の設定
  background(0, 0, 0);
  
  // フレームの描画（外側）
  fill(211, 209, 209);
  noStroke();
  ellipse(cx, cy, clockDiameter+50, clockDiameter+50);

  // フレームの描画（内側）
  fill(243, 242, 242);
  noStroke();
  ellipse(cx, cy, clockDiameter+10, clockDiameter+10);



  // 文字盤背景の設定
  fill(255, 255, 255);
  noStroke();
  ellipse(cx, cy, clockDiameter, clockDiameter);


  float shadow = 2.0;

  // 刻み（nick）の表示
  fill(50, 50, 50);
  for ( int a = -90; a < 360-90; a = a + 6 ) {
    float angle = radians(a);
    float length;
    stroke(10);
    if ( a%30 == 0) {
      length = nickRadius/6.0;
      strokeWeight(10);
    } else {
      length = nickRadius/10.0;
      strokeWeight(1);
    }

    stroke(0, 0, 0, 50);
    line(
      cx+cos(angle)*(nickRadius-length)-shadow, cy+sin(angle)*(nickRadius-length)-shadow, 
      cx+cos(angle)*(nickRadius)-shadow, cy+sin(angle)*(nickRadius)-shadow
      );
    stroke(10);
    line(
      cx+cos(angle)*(nickRadius-length), cy+sin(angle)*(nickRadius-length), 
      cx+cos(angle)*(nickRadius), cy+sin(angle)*(nickRadius)
      );
  }

  text("Prototyping clock", 233, 397);
  // 文字の表示（1から右回りに12まで、順番に描画しています）
  /*
  int hour=1;
   shadow = 2;
   for ( int a = -60; a < 360-60; a = a + 30 ) {
   float angle = radians(a);
   fill(0,0,0, 50);
   text(hour, 
   cx+cos( angle )*numberRadius-shadow, 
   cy+sin( angle )*numberRadius-shadow);
   fill(50);
   text(hour, 
   cx+cos( angle )*numberRadius, 
   cy+sin( angle )*numberRadius);
   hour++;
   }
   */

  // 長針、短針、秒針の表示
  // それぞれの時刻に合わせて、針を回転させるべき角度を計算しています。
  float s = map(second(), 0, 60, 0, TWO_PI) - HALF_PI; // 秒針
  float m = map(minute() + norm(second(), 0, 60), 0, 60, 0, TWO_PI) - HALF_PI; // 分針 
  float h = map(hour() + norm(minute(), 0, 60), 0, 24, 0, TWO_PI * 2) - HALF_PI; // 時針

  shadow = 4.0;
  stroke(0, 0, 0, 50); 

  strokeWeight(15);
  line(cx-shadow, cy-shadow, cx + cos(h) * hoursRadius-s-shadow, cy + sin(h) * hoursRadius-shadow);
  strokeWeight(10);
  line(cx-shadow, cy-shadow, cx + cos(m) * minutesRadius-shadow, cy + sin(m) * minutesRadius-shadow);
  strokeWeight(2);
  line(cx-shadow, cy-shadow, cx + cos(s) * secondsRadius-shadow, cy + sin(s) * secondsRadius-shadow);

  stroke(50, 50, 50); 
  strokeWeight(15);
  line(cx, cy, cx + cos(h) * hoursRadius, cy + sin(h) * hoursRadius);
  strokeWeight(10);
  line(cx, cy, cx + cos(m) * minutesRadius, cy + sin(m) * minutesRadius);
  stroke(255, 0, 0);
  strokeWeight(2);
  line(cx, cy, cx + cos(s) * secondsRadius, cy + sin(s) * secondsRadius);

  stroke(0, 0, 0, 50);
  fill(50, 50, 50);
  ellipse(width/2, width/2, 20, 20);
  fill(70, 70, 70);
  ellipse(width/2, width/2, 15, 15);
}
