/**
 * Digital Clock. 
 *  by Tetsuaki Baba
 */
PFont f;                        // Font表示用
String getWeekName() {
  /*
  計算方法はツェラーの公式を参照
   https://ja.wikipedia.org/wiki/%E3%83%84%E3%82%A7%E3%83%A9%E3%83%BC%E3%81%AE%E5%85%AC%E5%BC%8F
   */
  int y = year();
  int m = month();
  int d = day();
  int Y=y % 100;
  int C=int(y/100);
  int L=-2*C+C/4;
  switch( (d+26*(m+1)/10+Y+Y/4+L)%7 )
  {
  case 1:
    return "Sun";
  case 2:
    return "Mon";
  case 3:
    return "Tue";
  case 4:
    return "Wed";
  case 5:
    return "Thr";
  case 6:
    return "Fri";
  case 0:
    return "Sat";
  }
  return "Error";
}

void setup() {
  size(800, 800);
  pixelDensity(displayDensity());

  //  指定フォントで文字を作成する場合、Processingのツールメニューにある、フォント作成を利用してください。
  f = createFont("HelveticaNeue-UltraLight.otf", 50);  
  textFont(f); // 読み込んだフォント f を表示用テキストフォントに変更
  textAlign(CENTER, CENTER); // 表示基準を中心に設定
}

void draw() {

  // 背景色の設定
  background(135, 206, 235);


  int grid_x = width/16;
  int grid_y = height/16;
  text(month(), 6*grid_x, grid_y*7.5);
  text(day(), 8*grid_x, grid_y*7.5);
  text(getWeekName(), 10*grid_x, grid_y*7.5); 

  text(hour(), 6*grid_x, grid_y*8.5);
  text(":", 7*grid_x, grid_y*8.5);
  text(minute(), 8*grid_x, grid_y*8.5);
  text(":", 9*grid_x, grid_y*8.5);
  text(second(), 10*grid_x, grid_y*8.5);
}
