Metro metro;
Layer[] layer;

int play_pos = 0;
int play_pos_previous = 0;
int selected_layer = 0;

void setup()
{
  size(500, 500); 
  frameRate(1000); // シーケンスを正確に動かすために目一杯早くする

  // Metroの初期化
  metro = new Metro();
  metro.set(100); // 100[ms]おきにtrueを返す

  layer = new Layer[3];

  for ( int i = 0; i < 3; i++ ) {
    layer[i] = new Layer();
  }
  layer[0].setup("CHH.wav");
  layer[0].setSqColor(color(250,0,0));
  
  layer[1].setup("SD.wav");
  layer[1].setSqColor(color(0,250,0));

  layer[2].setup("BD.wav");
  layer[2].setSqColor(color(0,0,250));
}


void draw()
{
  background(0);

  layer[selected_layer].updateButtonStatus();
  boolean flg = metro.update();
  for( int i = 0; i < 3; i++ ){
    layer[i].update(flg);
  }
  layer[selected_layer].draw();
  
  fill(255);
  text("Layer: " + str(selected_layer+1), 20, 20);
  
}

void keyPressed()
{
  switch(key)
  {
  case '1':
    selected_layer = 0;
    break;
  case '2':
    selected_layer = 1;
    break;
  case '3':
    selected_layer = 2;
    break;
  }

  // Screenshot用
  if ( key == 's' ) {
    String name = year()+"-"+month()+"-"+day()+"-"+hour()+"-"+minute()+"-"+second() + ".png";
    save(name);
  }
}
