#include "ofApp.h"

//--------------------------------------------------------------
void ofApp::setup(){
    sound_utils.setup(512);
    graph_volume.setup("Sound Volume");
    graph_volume.setColor(ofColor::black);
    graph_volume.setBufSize(512);
    graph_100_1000.setup("Power Spectrum 100 to 1000[Hz]");
    graph_100_1000.setColor(ofColor::black);
    graph_100_1000.setBufSize(512);
    graph_3000_8000.setup("Power Spectrum 3000 to 8000[Hz]");
    graph_3000_8000.setColor(ofColor::black);
    graph_3000_8000.setBufSize(512);
    
    panel.setup("settings");
    panel.add( threshold.set("Threshold", 5.0, 0.0, 10.0));
    is_sound_on = false;
    
    font_result.load(ofToDataPath("ofxGraph/DIN Alternate Bold.ttf"), 48);
    str_result = "";
    alpha = 0.0;
}

//--------------------------------------------------------------
void ofApp::update(){
    sound_utils.update();
    if( sound_utils.fft.avg_power > threshold ){
        graph_volume.add(sound_utils.fft.avg_power,
                         OFXGRAPH_POINT_LABEL_MARKER);
    }
    else{
        graph_volume.add(sound_utils.fft.avg_power);
    }
    
    volume.push_back(sound_utils.fft.avg_power);
    while( volume.size() > ofGetWidth()){
        volume.erase(volume.begin());
    }
    
    float sum_100_1000 = 0.0;
    float sum_3000_8000 = 0.0;
    int count_100_1000 = 0;
    int count_3000_8000 = 0;
    for( int i = 0; i < sound_utils.fft.spectrum.size(); i++){
        if(sound_utils.fft.spectrum[i].Hz >= 100 &&
           sound_utils.fft.spectrum[i].Hz <= 1000 ){
            sum_100_1000 = sum_100_1000 + sound_utils.fft.spectrum[i].power;
            count_100_1000++;
        }
        else if(sound_utils.fft.spectrum[i].Hz >= 3000 &&
                sound_utils.fft.spectrum[i].Hz <= 8000 ){
            sum_3000_8000 = sum_3000_8000 + sound_utils.fft.spectrum[i].power;
            count_3000_8000++;
        }
    }
    float ave_100_1000 = sum_100_1000/(float)count_100_1000;
    float ave_3000_8000 = sum_3000_8000/(float)count_3000_8000;
    volume_100_1000.push_back(ave_100_1000);
    volume_3000_8000.push_back(ave_3000_8000);
    while( volume_100_1000.size() > ofGetWidth() ){
        volume_100_1000.erase(volume_100_1000.begin());
    }
    while( volume_3000_8000.size() > ofGetWidth() ){
        volume_3000_8000.erase(volume_3000_8000.begin());
    }
    
    if( sound_utils.fft.avg_power > threshold ){
        graph_100_1000.add(ave_100_1000);
        tap.push_back(ave_100_1000);
        graph_3000_8000.add(ave_3000_8000);
        swipe.push_back(ave_3000_8000);
    }
    
    if(sound_utils.fft.avg_power > threshold &&
       is_sound_on == false ){
        is_sound_on = true;
        graph_100_1000.clear();
        graph_3000_8000.clear();
        tap.clear();
        swipe.clear();
    }
    else if( sound_utils.fft.avg_power < threshold &&
            is_sound_on == true ){
        is_sound_on = false;
        float sum_tap = 0.0;
        for( int i = 0; i < tap.size(); i++ ){
            sum_tap = sum_tap + tap[i];
        }
        float sum_swipe = 0.0;
        for( int i = 0; i < swipe.size(); i++ ){
            sum_swipe = sum_swipe + swipe[i];
        }

        if( sum_tap/sum_swipe > 10 ){
            str_result = "Tap";
            cout << "Tap!!" << endl;
        }
        else{
            str_result = "Swipe";
            cout << "Swipe!!" << endl;
        }
        alpha = 255;
    }
}

//--------------------------------------------------------------
void ofApp::draw(){
    sound_utils.drawSpectrum(20,20, ofGetWidth()-40, 200);
    graph_volume.draw();
    graph_100_1000.draw();
    graph_3000_8000.draw();
    panel.draw();
    
    alpha--;
    if( alpha <= 0 )alpha = 0;
    ofSetColor( 0,0,0, alpha);
    font_result.drawString(str_result, ofGetWidth()/2, ofGetHeight()/2);
}

void ofApp::keyPressed(int key)
{
    if( key == ' ' ){
        graph_volume.toggle_pause = !graph_volume.toggle_pause;
        graph_100_1000.toggle_pause = !graph_100_1000.toggle_pause;
        graph_3000_8000.toggle_pause = !graph_3000_8000.toggle_pause;
        
    }
}

