import processing.sound.*;

class Layer {

  Layer() {
  }

  void setup(String filename)
  {
    button  = new Button[16];
    for ( int i = 0; i < 16; i++ ) {
      button[i] = new Button();
      button[i].setup(100+(i%4)*100, 100+(i/4)*100, false);
    }
    // 再生音声ファイルの読み込み
    sound = new SoundFile(sq.this, filename);
    
    color_sq = color(250);
  }
  void updateButtonStatus()
  {
    for ( int i = 0; i < 16; i++ ) {
      button[i].update();
    }
  }
  void update(boolean _metro)
  {
    if ( _metro == false ) {

      return;
    }

    // ボタンが押されているなら
    if ( button[play_pos_previous].status == true ) {
      button[play_pos_previous].c = color(200);
    }
    // 一つ前の該当ボタンは 50 の色に戻す
    else {
      button[play_pos_previous].c = color(50);
    }

    // シーケンス箇所を一つ進める
    play_pos++;
    if ( play_pos > 15 )play_pos = 0;

    // そのシーケンス箇所は color_sq の白色にする
    button[play_pos].c = color(color_sq);
    if ( button[play_pos].status == true ) {
      sound.play();// 音を鳴らす
    }

    // 古いシーケンス場所として保存しておく。
    play_pos_previous = play_pos;
  }

  void draw()
  {
    for ( int i =0; i < 16; i++ ) {
      button[i].draw();
    }
  }
  
  void setSqColor(color _color){
    color_sq = _color;
  }
  Button[] button;
  SoundFile sound;
  int play_pos;
  int play_pos_previous;
  color color_sq;
}
